/*
    Event.c -- Version 3.0 
    
    Developer Technical Support Apple II Sample Code

    Copyright (c) 1990 by Apple Computer, Inc.
    All Rights Reserved.

    Contains the main event loop for the network aware sample
    application.  It also contains the routines to highlight
    or dim menu items depending on whether a desk accessory
    window is the front window.
*/

#include <Window.h>                     /* {CIIGSIncludes}Window.h */
#include <Menu.h>                       /* {CIIGSIncludes}Menu.h */
#include "Aware.h"


extern int quitFlag;
extern WmTaskRec event;
extern GrafPortPtr lastWindow;


/*
    enableDAItems()
    
    This routine enables the menu items and menus necessary
    when a desk accessory is in the frontmost window.  In our
    case, it enables the Close item in the File menu, and
    enables the Edit menu.
*/
void    enableDAItems()
{
    EnableMItem(CloseItem);
    SetMenuFlag(0xFF7F, EditMenuID);        /* enable the edit menu */
}



/*
    enableApplItems()
    
    This routine enables the menu items and menus necessary
    when a desk accessory is not in the frontmost window.
    In our case, it enables the Load Configuration and
    Save Configuration items in the File menu.
*/
void    enableAppItems()
{
    EnableMItem(LoadConfigItem);
    EnableMItem(SaveConfigItem);
}


/*
    disableDAItems()
    
    This routine disables the menu items and menus used by
    a desk accessory.  In our case, it disables the Close
    item in the File menu and disables the Edit menu.
*/
void    disableDAItems()
{
    DisableMItem(CloseItem);
    SetMenuFlag(0x0080, EditMenuID);        /* disable the edit menu */
}


/*
    disableApplItems()
    
    This routine disables the menu items and menus used by
    the main application.  In our case, it disables the
    Load Configuration and Save Configuration options in the
    File menu.
*/
void    disableAppItems()
{
    DisableMItem(LoadConfigItem);
    DisableMItem(SaveConfigItem);
}



/*
    checkFrontW()
    
    This routine determines which window (if any) is frontmost
    and updates the menu items as necessary.
*/
void    checkFrontW()
{
    GrafPortPtr     theWindow;

    theWindow = FrontWindow();

    /*  If the front window hasn't changed since the last time
        we checked, then there is no need to change the menu
        items. */
    if (theWindow == lastWindow) return;

    if (!theWindow) {           /* If no front window... */
        disableDAItems();       /* Turn off desk accessory items */
        enableAppItems();       /* Turn on the application's items */
    }
    else {                      /* Look at what kind of window we have... */
        if (GetSysWFlag(theWindow)) {
            /* It's a DA */
            disableAppItems();  /* Turn off the application's items */
            enableDAItems();    /* Turn on the DA items */
        }
        else {
            /* A window other than a DA window */
            disableDAItems();   /* Turn off DA items */
            enableAppItems();   /* Turn on application items */
        }
    }

    DrawMenuBar();              /* Redraw menu bar to reflect the changes */
    lastWindow = theWindow;     /* Remember which window it was */
}



/*
    mainEvent()
    
    This is the event loop of our sample application.  It's quite
    simple because TaskMaster handles almost everything for us.
*/
void mainEvent()
{
    while (!quitFlag) {                 /* Repeat until user selects Quit */
        checkFrontW();                  /* set menus according to front window */
        switch(TaskMaster(0xFFFF, &event)) {    /* Have TaskMaster handle an event */
            case wInSpecial:            /* Was it a menu item for a DA? */
            case wInMenuBar:            /* Or in the menu bar? */
                doMenu();               /* Yes, so handle the menu selection */
                break;                  /* and exit the switch() statement */
        }
    }
}
